% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly.chron.R
\name{poly.chron}
\alias{poly.chron}
\title{Plot medians and confidence zones for simulation results.}
\usage{
poly.chron(results, field.list = NULL, quant = c(0.025, 0.975),
  col.list = c("darkred", "darkgreen", "blue", "grey", "goldenrod"),
  opacity = 80, ylim = NULL, med.line = TRUE, border = NA,
  small.n = NULL, small.n.op = 126, add = FALSE, legend = TRUE, ...)
}
\arguments{
\item{results}{A list resembling the output from date.simulate or a related function, or a data table resembling the second component
thereof - i.e. the summary simulation results.}

\item{field.list}{A character vector of values in results$id to be plotted. Defaults to NULL, in which case all suitable
values are used.}

\item{quant}{Numeric vector of length 2: lower and upper quantiles to define confidence zone. Defaults to c(0.025, 0.975), i.e. 95pc.}

\item{col.list}{Character vector: colours to be used for each column plotted. Defaults to c("darkred", "darkgreen", "blue", "grey",
"goldenrod"). Nb. if more than five groups are plotted then the default colours will start to recycle.}

\item{opacity}{Numeric: opacity of each line. Defaults to 80.}

\item{ylim}{Numeric: an easy way to override the built-in scaling in plot - if a vector of length 1 is passed it will
be converted into c(0, ylim) to be passed to the ylim argument in plot. Alternatively a vector of length 2 will be passed
straight to plot as is. Defaults to NULL, in which case the built-in scaling in plot takes over.}

\item{med.line}{Logical: should a median line be plotted on top of eachconfidence polygon? Defaults to TRUE.}

\item{border}{Character: what type of border should the polygons have? Defaults to NA, i.e. no border.}

\item{small.n}{Character vector of colours to be used for boxes marking periods of low "effort", when plotting cpue results. Has no
effect if 'results' doesn't have a third element called "small.n". Defaults to NULL, in which case no boxes are plotted.}

\item{small.n.op}{Numeric vector of length equal to 'small.n' (or otherwise recycled to that length) specifying opacity for small.n
boxes. Defaults to 126.}

\item{add}{Logical: should data be added to current plot, or should axis.setup be called to start a new plot? Defaults to FALSE.}

\item{legend}{Logical: should an automatic legend of column names and corresponding colours be plotted? Defaults to TRUE.}

\item{...}{Other graphical arguments to be passed to plot. Nb. (a) includes special arguments for axis.setup (currently just 'lab.sp'),
(b) 'ylab' will default to "Estimated frequency density", as per axis.setup, unless specified here.}
}
\value{
None.
}
\description{
Plots defined confidence intervals (as polygons) and medians (as lines) for output from date.simulate or an associated function.
}
\examples{
date.ranges <- data.table(Start=c(450, 450, 600), End=c(700, 800, 650), frags=c(3, 6, 25))
x <- freq.simulate(date.ranges, weight=date.ranges$frags, bin.width=50, reps=200)
poly.chron(x, field.list=c("dummy", "count"))

}

